 /////////////////////////////////////////////////////////////////////////// 
//                                 VSS3.c                                //     
//                         James Austin  05.03.03                        //     
///////////////////////////////////////////////////////////////////////////
//                          www.fordscorpio.co.uk                        //
//          Program for Lock on Go using VSS Ford Scorpio 1995+          //
//                      Code for CCS PCM C Compiler                      //
//                           uses PIC16F628                              //
///////////////////////////////////////////////////////////////////////////                                                                      
//Inputs/Outputs:                                                        //
//    RB1 Digital input for Lock Signal                                  //
//    RB3 Digital I/O on CN7.2 (used here as ext sounder output)         //
//    RB4 Digital input for VSS sensor 2.2Hz/1MPH aprox 2 PPS            //
//    RB5 Digital output to Lock Relay                                   //
//    RB6 RS232 xmit                                                     //
//    RB7 RS232 rcv                                                      //
///////////////////////////////////////////////////////////////////////////
//Variables:                                                             //
//     Main:                                                             //
//     CalbNo: Calibration Number 0 to 255.  125 Default                 //
//     LockDelay: Delay in MS Lock Relay is on for                       //
//     Alarm1 & Alarm2: Setpoints in MPH for overspeed alarms            //
//     HalfSpeed: Pulses in one iteration of loop, 2 iterations made-    //
//               as RTCC is 8 bits & speed at 85MPH = 255                //
//     LockSpeed: Speed when doors lock                                  //
//     Delay1 & Delay2: Counts around loop before Speed Alarm            //
//     n: Counter used in RS232 Detection loop                           //
//     Speed: 16 bit of Speed                                            //
//     LockStopGo, LoopTwice, Locked, Alarm1Done, Alarm2Done:  Flags     //
//     Comms:                                                            //
//     code: used to store values in RS232 & for input to eeprom         //
//     CalbNo: Calibration Number 0 to 255 in RS232                      //
//     LockDelay: Delay in MS Lock Relay is on for.  In RS232            //
//     SetPoint: Speed Alarms set points in RS232                        //
//     string[4] Array used in RS232 to store char strings               //
//     Alarm:                                                            //
//     x: Loop counter for alarm                                         //
///////////////////////////////////////////////////////////////////////////
//Functions:                                                             //
//     main: Checks for RS232, Loads values from eeprom-                 //  
//           , calculates speed, locks doors and sends speed to RS232    //                                                
//     Comms: Sets up values to store in eeprom, values from RS232       //
//     Alarm: Places 4096Hz pulse on sounder pin                         //
///////////////////////////////////////////////////////////////////////////                                                                 
//   NO WARRANTIES, GUARANTIES OR PROMISES GIVEN ABOUT CODE OR HARDWARE  //
//                      DIY EXPERIMENTAL USE ONLY                        //
//                                                                       //
//   ASCII "1" (49) sent to RS232 on start up, boots into Setup mode     //
//     Speed is calculated every 2 iterations of the dowhile loop        //
//        The Lock Relay is energised for a set time at LockSpeed        //
// and then if selected, again after doors open and speed drops to 0MPH  //
//   2 Speed Alarms will chime the sounder when the setpoints are hit    //
//                Speed is sent out on the RS232 in MPH                  //                                            //
///////////////////////////////////////////////////////////////////////////               
//                                                                       //        
//Revisions:                                                             //
//                                                                       //
//                                                                       //
///////////////////////////////////////////////////////////////////////////


#include <16F628.h>
#use delay (clock=4000000,RESTART_WDT)
#use rs232(baud=9600, xmit=PIN_B6, rcv=PIN_B7, RESTART_WDT, ERRORS)

#fuses HS,WDT,PUT                                    //highspeed, watchdog, power up timer fuses

void Comms(void);
void Alarm(void);



 main()
 
 {
   
   int CalbNo, LockDelay, Alarm1, Alarm2, HalfSpeed, LockSpeed, Delay1, Delay2;
   long n, y, Speed = 0;
   short LockStopGo, LoopTwice = 0, Locked = 0, Alarm1Done = 0, Alarm2Done = 0;

   setup_counters (RTCC_EXT_L_TO_H,WDT_72MS);        //RTCC Counter low to high edge-
   set_rtcc(0);                                      //Watch dog 72mS

   port_b_pullups(TRUE);                             //No hardware resistors on RS232 so pull up
   output_low(PIN_B5);                               //Turn Relay off
   output_low(PIN_B3);                               //Aux output off
   output_low(PIN_A2);                               //Turn led off

   for (n=20000;n!=0; n--)                           //Check for comms on RS232 for-
    {                                                //2 sec after power up.
     delay_us(100);
     restart_wdt();
     if(kbhit() )                                    //If detected call Comms function.
     Comms();
    }

   CalbNo = read_eeprom(0);                          //Load values from eeprom
   LockDelay = read_eeprom(1);   
   LockStopGo = read_eeprom(2);
   Alarm1 = read_eeprom(3); 
   Alarm2 = read_eeprom(4);
   LockSpeed = read_eeprom(5);   
   //read_eeprom(6);                                 //Not used here
   //read_eeprom(7);                                 //
   //read_eeprom(8);                                 //
   //read_eeprom(9);                                 //
   restart_wdt();
   set_rtcc(0);                                      //Reset RTCC counter

   do
    {
     restart_wdt();
     delay_ms(373);
     restart_wdt();                                  //373 + CalbNo of 127 = 500Ms, this allows-
     delay_ms(CalbNo);                               //Iteration time to be adjusted using CalbNo.
    
     HalfSpeed = (get_rtcc());                       //Get Count from RTCC.
     set_rtcc(0);                                    //Reset Counter.
     Speed = (HalfSpeed + Speed);                    //Speed = this RTCC count + last RTCC count-
                                                     

   
     if(LoopTwice)                                   //If LoopTwice Flag is set.
      {
        restart_wdt();
        Speed = (Speed/2);                           //2 pulses per 1 MPH (2.2Hz)
        printf("%c", (int)Speed);                    //Send Speed to RS232
   
        if(Speed >LockSpeed && !Locked)              //If speed above 5MPH and  NotLocked-                                                  
          {
           restart_wdt();                            //Flag is not set.
           output_high(PIN_B5);                      //Turn on Lock Relay.
           y = LockDelay;
           for (;y!=0; y--)
            {
             restart_wdt();
             delay_ms(10);
            }

           restart_wdt();                            //Wait for time set in LockDelay.
           output_low(PIN_B5);                       //Turn off Lock Relay.
           Locked = (true);                          //Set Locked flag to stop loop
          }

        if(!Input(PIN_B0) && Speed == 0 && LockStopGo) //If Locked signal off and speed-
          {                                            //=0 and LocokStopGo set.
           Locked = (false);
          }         
      
        //////////////////////////////////             //SPEED ALARM 1.
        if(Speed > Alarm1)                             
          {
           Delay1++;
        
           if(Delay1 > 5 && !Alarm1Done)               //Call Alarm if 6 iterations of the dowhile-
             {                                         //loop and Alarm1Done has not been set.
              Alarm();                                 //Call Alarm Func
              Alarm1Done = (true);                     //Set Alarm1Done.
              Delay1 = 0;
             }

          }
        else
          {
            Delay1 = 0;                               //Otherwise set Delay 1 to 0 and- 
            Alarm1Done = (false);                     //reset Alarm1Done.
          }
        /////////////////////////////////        
 
        //////////////////////////////////            //SPEED ALARM 2.
        if(Speed > Alarm2)                            //(as Alarm1)
          {
           Delay2++;
        
           if(Delay2 > 5 && !Alarm2Done)
             {
              Alarm();
              Alarm2Done = (true);
              Delay2 = 0;
             }

         }
        else
          {
            Delay2 = 0;
            Alarm2Done = (false);
          }
        /////////////////////////////////       
      
        Speed = 0;                                   //Set Speed to 0 and reset LoopTwice-
        LoopTwice = (false);                         //ready for next iteration of dowhile loop.
        restart_wdt();

      }
     else
      {

         LoopTwice = (true);                         //Set LoopTwice ready for next iteration-
         restart_wdt();                              //of dowhile loop.
      }



   
    }
     while(true);
  



  }

//end main




/////////////////////////////////////////////////////////////////////////////////////////////////
//                           Comms Function, Set up VSS parrameters                            //                                                      
/////////////////////////////////////////////////////////////////////////////////////////////////

 void Comms(void)                                       
  {

   int code, TestCh1;
   long CalbNo, LockDelay, SetPoint;
   char string[4];

   output_high(PIN_A2);                             //Turn led on   
   printf("C");   
   do
    {
     restart_wdt();

     switch(getch() )
       {
        case 82:
                                                     //If "R" read parameters to PC
            restart_wdt();
            printf("%c",read_eeprom(0));
            getch();
            printf("%c",read_eeprom(1));
            getch();
            printf("%c",read_eeprom(2));
            getch();
            printf("%c",read_eeprom(3));
            getch();
            printf("%c",read_eeprom(4));
            getch();
            printf("%c",read_eeprom(5));
            restart_wdt();
            break;

         case 87:                                   //If "W" write from PC
          
            restart_wdt();
            write_eeprom(0, getch());
            delay_ms(1);
            restart_wdt();
            write_eeprom(1, getch());
            delay_ms(1);     
            restart_wdt();
            write_eeprom(2, getch());
            delay_ms(1);
            restart_wdt();
            write_eeprom(3, getch());
            delay_ms(1);      
            restart_wdt();
            write_eeprom(4, getch());
            delay_ms(1);
            restart_wdt();
            write_eeprom(5, getch());
            delay_ms(1); 
            break;     
          
         
         case 84:                                   //If "T" terminal mode
          
            restart_wdt();
            printf("SCORPIO VSS SETUP\n\r");          //Terminal Display
            printf("\n\r");
            printf("www.fordscorpio.co.uk  2003\n\r");
            printf("\n\r");
            printf("1.Calibrate\n\r");
            printf("2.Lock Delay\n\r");
            printf("3.Lock on Stop Go\n\r");
            printf("4.Speed Alarms\n\r");
            printf("9.EXIT\n\r");
            restart_wdt();
            delay_ms(1000);
            restart_wdt();

            code = getch();
            restart_wdt();
            printf("\n\r");

            switch(code)
             {
              case 49:
                printf("Enter calibration Number\n\r");
                restart_wdt();
                gets(string);
                restart_wdt();
                if( (string[0] >47 && string[0] <51) && (string[1] >47 && string[1] <54) &&
                (string[2] >47 && string[2] <54) )
                 {
                  CalbNo = ( ((string[0]-48)*100) + ((string[1]-48)*10) + ((string[2]-48)) );
                  write_eeprom(0,CalbNo);
                 }
                else
                 {
                  printf("WRONG\n\r");
                 }             
                break;
 
              case 50:
                printf("Enter lock delay mS\n\r");
                restart_wdt();
                gets(string);
                restart_wdt();

                if( (string[0] >47 && string[0] <51) && (string[1] >47 && string[1] <54) &&
                (string[2] >47 && string[2] <54) )
                 {
                  LockDelay = ( ((string[0]-48)*100) + ((string[1]-48)*10) + ((string[2]-48)) );
                  write_eeprom(1,LockDelay);
                 }
                else
                 {
                  printf("WRONG\n\r");
                 }              
                break;

              case 51:
                printf("LOCK ON STOP GO:y n\n\r");
                restart_wdt();
                code = getch();
                restart_wdt();
                if(code == 121)
                write_eeprom(2,1);
                if(code == 110)
                write_eeprom(2,0); 
                break;

             case 52:
                printf("1.Alarm 1\n\r");
                printf("2.Alarm 2\n\r");
                restart_wdt();
                code = getch();
                restart_wdt();
                printf("Enter Alarm MPH\n\r");
                gets(string);
                restart_wdt();
                if( (string[0] >47 && string[0] <51) && (string[1] >47 && string[1] <54) &&
                  (string[2] >47 && string[2] <54) )
                   {
                    SetPoint = ( ((string[0]-48)*100) + ((string[1]-48)*10) + ((string[2]-48)) );
                   }
                  else
                   {
                    printf("WRONG\n\r");
                   }  
                 if(code == 49)
                  {
                   write_eeprom(3,SetPoint);
                  }
                 if(code == 50)
                  {
                   write_eeprom(4,SetPoint);
                  }
            
                  break;

              case 53:
                restart_wdt();
                code = getch();
                restart_wdt();
                write_eeprom(5,code);
                break;

             case 54:
                restart_wdt();
                code = getch();
                restart_wdt();
                write_eeprom(6,code);
                break;

              case 55:
                restart_wdt();
                code = getch();
                restart_wdt();
                write_eeprom(6,code);
                break;

               case 56:
                restart_wdt();
                code = getch();
                restart_wdt();
                write_eeprom(7,code);
                break;


              case 57:
                printf("GoodBye");
                do                                          
                 {
                                                           //wdt rests cpu
                 }
                while(true);

              default:
                printf("WRONG KEY");
                restart_wdt();
             }
             printf("\n\r");
             printf("1 for Menu\n\r");
             restart_wdt();

            break;                                       //end of Terminal case, break
           } 
           
        
                                                   
     }
    while(true);
  }



/////////////////////////////////////////////////////////////////////////////////////////////////
//                                      Alarm Function                                         //                                                      
/////////////////////////////////////////////////////////////////////////////////////////////////

void Alarm(void)

 {
  int x = 0;

  output_high(PIN_B3);                                     //Spare output CN7.2 on

  while(x < 100)                                           //Square wave piezo sounder driver
   {
    x++;
    restart_wdt();
    output_high(PIN_A1);   
    delay_us(120);
    restart_wdt();
    output_low(PIN_A1);
    delay_us(244);
    restart_wdt();
   }

  x = 0;
  output_low(PIN_B3);
   
 }
